using System;
using System.Data;
using System.Data.SqlClient;
using MethodBase = System.Reflection.MethodBase;
using gov.va.med.vbecs.ExceptionManagement;
//using gov.va.med.vbecs.Common;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Krzysztof Dobranowski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>04/23/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access component providing database read/write access for patient order data.
	///</summary>

	public class PatientOrder
	{
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/25/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2716"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>The DataTable containing the list of order priorities</ExpectedOutput>
		///	</Case>
		///<Case type="1" testid ="1220"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the list of order priorities
		/// </summary>
		/// <returns>DataTable containing order urgency data</returns>
		public static DataTable GetOrderUrgencyList()
		{
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetOrderUrgencyList.StoredProcName);
			
			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/6/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5268"> 
		///		<ExpectedInput>Valid parameters</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5269"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetOrderSearchDetails
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <param name="specimenUid"></param>
		/// <param name="patientSsn"></param>
		/// <param name="patientLastName"></param>
		/// <returns></returns>
		public static DataTable GetOrderSearchDetails(DateTime startDate, DateTime endDate, string specimenUid, string patientSsn, string patientLastName)
		{
			SqlParameter[] prms =
				{
					new SqlParameter(STOREDPROC.GetOrderSearchDetails.startdate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetOrderSearchDetails.enddate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetOrderSearchDetails.specimenuid, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.GetOrderSearchDetails.patientssn, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.GetOrderSearchDetails.patientlastname, System.Data.SqlDbType.VarChar),
					new SqlParameter(STOREDPROC.GetOrderSearchDetails.divisioncode, System.Data.SqlDbType.VarChar)
				};

			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = (specimenUid.Length == 0) ? null : specimenUid;
			prms[3].Value = (patientSsn.Length == 0) ? null : patientSsn;			
			prms[4].Value = (patientLastName.Length == 0) ? null : patientLastName;
			prms[5].Value = Common.LogonUser.LogonUserDivisionCode;

			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetOrderSearchDetails.StoredProcName, prms);

			return ds.Tables[0];

		}
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4046"> 
		///		<ExpectedInput>PatientOrderGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4047"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>Retrieves patient order data by given order GUID</summary>
		///<param name="patientOrderGuid">Patient order GUID</param>
		///<returns>DataTable containing patient order data</returns>
		public static DataTable GetPatientOrder(System.Guid patientOrderGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetPatientOrder.patientorderguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetPatientOrder.divisioncode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = patientOrderGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			return ( Common.StoredProcedure.GetData(STOREDPROC.GetPatientOrder.StoredProcName, prms).Tables[0]);
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/01/2004</CreationDate>
		///
		///<TestCases>
		///	
		///<Case type="0" testid ="3385"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>A valid Vbecs Order Number</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1223"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>Retrieves next VBECS order number (creates new)</summary>
		///<returns>DataTable containing order number</returns>
		public static DataTable GetNextVbecsOrderNumber()
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetNextVbecsOrderNumber.lastupdateuser, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetNextVbecsOrderNumber.lastupdatefunctionid, System.Data.SqlDbType.Int),
			};

			prms[0].Value = Common.LogonUser.LogonUserName;
			prms[1].Value = Common.UpdateFunction.UC045_FrmOrderSpecimenReflex;
			
			return ( Common.StoredProcedure.GetData(STOREDPROC.GetNextVbecsOrderNumber.StoredProcName, prms).Tables[0]);
		}

		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3379"> 
		///		<ExpectedInput>PatientOrderGuid, cprsOrderNumber, Divisioncode</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3380"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Static function retrieves patient order group information as a dataset
		/// </summary>
		/// <param name="patientOrderGuid">Patient order unique identifier</param>
		/// <param name="cprsOrderNumber">Cprs Order Number</param>
		/// <param name="divisionCode">Division code</param>
		/// <returns>Data set of patient order, ordered component and//or ordered test details</returns>
		public static DataSet PrintPatientOrderAlert(Guid patientOrderGuid, string cprsOrderNumber, string divisionCode)
		{
			System.Data.SqlClient.SqlParameter[] prms =
			{
				new System.Data.SqlClient.SqlParameter(STOREDPROC.PatientOrderAlertPrint.patientorderguid, System.Data.SqlDbType.UniqueIdentifier),
				new System.Data.SqlClient.SqlParameter(STOREDPROC.PatientOrderAlertPrint.cprsordernumber, System.Data.SqlDbType.VarChar),
				new System.Data.SqlClient.SqlParameter(STOREDPROC.PatientOrderAlertPrint.divisioncode, System.Data.SqlDbType.Char)
			};
			
			prms[0].Value = patientOrderGuid;
			prms[1].Value = cprsOrderNumber;
			//We cannot use Common.LogonUser.LogonUserDivisionCode because the HL7 service is not logged in to Vbecs 
			prms[2].Value = divisionCode;
			
			return Common.StoredProcedure.GetData(STOREDPROC.PatientOrderAlertPrint.StoredProcName, prms);
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2143"> 
		///		<ExpectedInput>OrderGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable of ReflexTests</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2144"> 
		///		<ExpectedInput>Empty Guid</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetReflexTestsForOrder
		/// </summary>
		/// <param name="orderGuid">OrderedComponentGuid or OrderedTestGuid</param>
		/// <returns></returns>
		public static DataTable GetReflexTestsForOrder(Guid orderGuid)
		{	
			if (orderGuid == Guid.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("orderGuid").ResString);
			}

			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetReflexTestsForOrder.OrderGuid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetReflexTestsForOrder.DivisionCode, System.Data.SqlDbType.VarChar)
			};
			//
			prms[0].Value = orderGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			//
			return Common.StoredProcedure.GetData(STOREDPROC.GetReflexTestsForOrder.StoredProcName, prms).Tables[0];
		}
	}
}
